/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.game.gamemode;

import dev.doctor4t.wathe.api.GameMode;
import dev.doctor4t.wathe.api.WatheRoles;
import dev.doctor4t.wathe.cca.GameRoundEndComponent;
import dev.doctor4t.wathe.cca.GameTimeComponent;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.game.GameFunctions;
import dev.doctor4t.wathe.index.WatheItems;
import dev.doctor4t.wathe.util.AnnounceWelcomePayload;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class LooseEndsGameMode
extends GameMode {
    public LooseEndsGameMode(class_2960 identifier) {
        super(identifier, 60, 2);
    }

    @Override
    public void initializeGame(class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        for (class_3222 player : players) {
            player.method_31548().method_5448();
            class_1799 derringer = new class_1799((class_1935)WatheItems.DERRINGER);
            class_1799 knife = new class_1799((class_1935)WatheItems.KNIFE);
            int cooldown = GameConstants.getInTicks(1, 0);
            class_1796 itemCooldownManager = player.method_7357();
            itemCooldownManager.method_7906(WatheItems.DERRINGER, cooldown);
            itemCooldownManager.method_7906(WatheItems.KNIFE, cooldown);
            player.method_7270(new class_1799((class_1935)WatheItems.CROWBAR));
            player.method_7270(derringer);
            player.method_7270(knife);
            gameWorldComponent.addRole((class_1657)player, WatheRoles.LOOSE_END);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnounceWelcomePayload(RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.indexOf(RoleAnnouncementTexts.LOOSE_END), -1, -1));
        }
    }

    @Override
    public void tickServerGameLoop(class_3218 serverWorld, GameWorldComponent gameWorldComponent) {
        GameFunctions.WinStatus winStatus = GameFunctions.WinStatus.NONE;
        if (!((GameTimeComponent)GameTimeComponent.KEY.get((Object)serverWorld)).hasTime()) {
            winStatus = GameFunctions.WinStatus.TIME;
        }
        int playersLeft = 0;
        class_1657 lastPlayer = null;
        for (class_1657 player : serverWorld.method_18456()) {
            if (!GameFunctions.isPlayerAliveAndSurvival(player)) continue;
            ++playersLeft;
            lastPlayer = player;
        }
        if (playersLeft <= 0) {
            GameFunctions.stopGame(serverWorld);
        }
        if (playersLeft == 1) {
            gameWorldComponent.setLooseEndWinner(lastPlayer.method_5667());
            winStatus = GameFunctions.WinStatus.LOOSE_END;
        }
        if (winStatus != GameFunctions.WinStatus.NONE && gameWorldComponent.getGameStatus() == GameWorldComponent.GameStatus.ACTIVE) {
            ((GameRoundEndComponent)GameRoundEndComponent.KEY.get((Object)serverWorld)).setRoundEndData(serverWorld.method_18456(), winStatus);
            GameFunctions.stopGame(serverWorld);
        }
    }
}

